<script type="text/template" id="connect_jetpack_template">
<?php if ( ! defined( 'JETPACK_STEP_AUTO_REDIRECT' ) || get_transient( 'jetpack_tried_to_connect' ) ) : ?>
<div class="jetpack-hero">
	<?php if ( ! empty( $step->label ) ) : ?>
	<h1 class="jetpack-hero__title"><?php echo esc_html( $step->label ); ?></h1>
	<div class="flyby">
		<svg class="flyer" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="87px" viewBox="0 0 80 87" enable-background="new 0 0 80 87" xml:space="preserve">
		    <polygon class="eye" fill="#518d2a" points="41.187,17.081 46.769,11.292 50.984,15.306   "></polygon>
		    <path class="body" fill="#518d2a" d="M38.032,47.3l4.973-5.157l7.597,1.996l0.878-0.91l0.761-0.789l-0.688-2.838l-0.972-0.926l-1.858,1.926 l-2.206-2.1l3.803-3.944l0.09-3.872L80,0L61.201,10.382L60.2,15.976l-5.674,1.145l-8.09-7.702L34.282,22.024l8.828-1.109 l2.068,2.929l-4.996,0.655l-3.467,3.595l0.166-4.469l-4.486,0.355L21.248,35.539l-0.441,4.206l-2.282,2.366l-2.04,6.961 L27.69,37.453l4.693,1.442l-2.223,2.306l-4.912,0.095l-7.39,22.292l-8.06,3.848l-2.408,9.811l-3.343-0.739L0,86.739l30.601-31.733 l8.867,2.507l-7.782,8.07l-1.496-0.616l-0.317-2.623l-7.197,7.463l11.445-2.604l16.413-7.999L38.032,47.3z M42.774,16.143 l3.774-3.914l2.85,2.713L42.774,16.143z"></path>
		</svg>
		<svg class="flyer" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="87px" viewBox="0 0 80 87" enable-background="new 0 0 80 87" xml:space="preserve">
		    <polygon class="eye" fill="#518d2a" points="41.187,17.081 46.769,11.292 50.984,15.306   "></polygon>
		    <path class="body" fill="#518d2a" d="M38.032,47.3l4.973-5.157l7.597,1.996l0.878-0.91l0.761-0.789l-0.688-2.838l-0.972-0.926l-1.858,1.926 l-2.206-2.1l3.803-3.944l0.09-3.872L80,0L61.201,10.382L60.2,15.976l-5.674,1.145l-8.09-7.702L34.282,22.024l8.828-1.109 l2.068,2.929l-4.996,0.655l-3.467,3.595l0.166-4.469l-4.486,0.355L21.248,35.539l-0.441,4.206l-2.282,2.366l-2.04,6.961 L27.69,37.453l4.693,1.442l-2.223,2.306l-4.912,0.095l-7.39,22.292l-8.06,3.848l-2.408,9.811l-3.343-0.739L0,86.739l30.601-31.733 l8.867,2.507l-7.782,8.07l-1.496-0.616l-0.317-2.623l-7.197,7.463l11.445-2.604l16.413-7.999L38.032,47.3z M42.774,16.143 l3.774-3.914l2.85,2.713L42.774,16.143z"></path>
		</svg>
		<svg class="flyer" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="87px" viewBox="0 0 80 87" enable-background="new 0 0 80 87" xml:space="preserve">
		    <polygon class="eye" fill="#518d2a" points="41.187,17.081 46.769,11.292 50.984,15.306   "></polygon>
		    <path class="body" fill="#518d2a" d="M38.032,47.3l4.973-5.157l7.597,1.996l0.878-0.91l0.761-0.789l-0.688-2.838l-0.972-0.926l-1.858,1.926 l-2.206-2.1l3.803-3.944l0.09-3.872L80,0L61.201,10.382L60.2,15.976l-5.674,1.145l-8.09-7.702L34.282,22.024l8.828-1.109 l2.068,2.929l-4.996,0.655l-3.467,3.595l0.166-4.469l-4.486,0.355L21.248,35.539l-0.441,4.206l-2.282,2.366l-2.04,6.961 L27.69,37.453l4.693,1.442l-2.223,2.306l-4.912,0.095l-7.39,22.292l-8.06,3.848l-2.408,9.811l-3.343-0.739L0,86.739l30.601-31.733 l8.867,2.507l-7.782,8.07l-1.496-0.616l-0.317-2.623l-7.197,7.463l11.445-2.604l16.413-7.999L38.032,47.3z M42.774,16.143 l3.774-3.914l2.85,2.713L42.774,16.143z"></path>
		</svg>
	</div>
	<?php endif; ?>
	<div class="jetpack-hero__info">
		<p class="step-description"><?php _e( 'Jetpack supercharges your self‑hosted WordPress site with the awesome cloud power of WordPress.com at no additional cost.', 'jetpack-start' ) ?></p>
		<div class="jetpack-box">
			<a class="button--primary" href="<?php echo Jetpack::init()->build_connect_url() ?>" class="jetpack-link" target="_top"><?php echo  __( 'Connect to WordPress.com', 'jetpack-start' );  ?></a>
			<div class="skip">
				<?php printf( __( ' or, <a href="%s" class="next">skip this step</a>', 'jetpack-start' ), home_url() ); ?>
			</div>
		</div>
	</div>
</div>
<?php endif	?>
</script>

<script>
	(function( $ ) {
		var StepView = JetpackStartStepView.extend( {
			template_id : '#connect_jetpack_template',

			events: {
				"click a.next": "goToNextStep"
			},

			<?php if ( defined( 'JETPACK_STEP_AUTO_REDIRECT' ) && false === get_transient( 'jetpack_tried_to_connect' ) ) : ?>
			beforeRender: function() {
				window.location = '<?php echo add_query_arg( 'src', JETPACK_STEP_AUTO_REDIRECT_SRC, Jetpack::init()->build_connect_url( true ) ); ?>';
				StepView.template_id = '#waiting-redirect';
			}
			<?php endif	?>

		});

		jetpackStartWizard.addStep(
			new JetpackStartStep( {
				view: StepView,
				slug: '<?php echo $step->slug; ?>',
				sort: '<?php echo $step->sort; ?>',
				conditional_display: function( step ) {
					return <?php echo ( ! Jetpack::init()->is_active() && false === get_transient( 'jetpack_tried_to_connect' ) ) ? 'true' : 'false'; ?>;
				}
			} )
		);
	}) ( jQuery );
</script>
